/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import java.util.Set;
import org.python.Version;
import org.python.core.CodeFlag;
import org.python.core.Py;
import org.python.core.PyFrame;

public class CompilerFlags
implements Serializable {
    public static final int PyCF_SOURCE_IS_UTF8 = 256;
    public static final int PyCF_DONT_IMPLY_DEDENT = 512;
    public static final int PyCF_ONLY_AST = 1024;
    public boolean only_ast;
    public boolean dont_imply_dedent;
    public boolean source_is_utf8;
    public String encoding;
    private final Set<CodeFlag> flags = Version.getDefaultCodeFlags();
    private static final int CO_ALL_FEATURES = 0x700 | CodeFlag.CO_NESTED.flag | CodeFlag.CO_GENERATOR_ALLOWED.flag | CodeFlag.CO_FUTURE_DIVISION.flag | CodeFlag.CO_FUTURE_ABSOLUTE_IMPORT.flag | CodeFlag.CO_FUTURE_WITH_STATEMENT.flag;

    public CompilerFlags() {
    }

    public CompilerFlags(int n) {
        for (CodeFlag codeFlag : CodeFlag.parse(n)) {
            this.setFlag(codeFlag);
        }
        this.only_ast = this.isEnabled(n, 1024);
        this.dont_imply_dedent = this.isEnabled(n, 512);
        this.source_is_utf8 = this.isEnabled(n, 256);
    }

    private boolean isEnabled(int n, int n2) {
        return (n & n2) != 0;
    }

    public int toBits() {
        int n = (this.only_ast ? 1024 : 0) | (this.dont_imply_dedent ? 512 : 0) | (this.source_is_utf8 ? 256 : 0);
        for (CodeFlag codeFlag : this.flags) {
            n |= codeFlag.flag;
        }
        return n;
    }

    public void setFlag(CodeFlag codeFlag) {
        this.flags.add(codeFlag);
    }

    public boolean isFlagSet(CodeFlag codeFlag) {
        return this.flags.contains((Object)codeFlag);
    }

    public String toString() {
        return String.format("CompilerFlags[division=%s nested_scopes=%s generators=%s with_statement=%s absolute_import=%s only_ast=%s dont_imply_dedent=%s  source_is_utf8=%s]", this.isFlagSet(CodeFlag.CO_FUTURE_DIVISION), this.isFlagSet(CodeFlag.CO_NESTED), this.isFlagSet(CodeFlag.CO_GENERATOR_ALLOWED), this.isFlagSet(CodeFlag.CO_FUTURE_WITH_STATEMENT), this.isFlagSet(CodeFlag.CO_FUTURE_ABSOLUTE_IMPORT), this.only_ast, this.dont_imply_dedent, this.source_is_utf8);
    }

    public static CompilerFlags getCompilerFlags() {
        return CompilerFlags.getCompilerFlags(0, null);
    }

    public static CompilerFlags getCompilerFlags(int n, PyFrame pyFrame) {
        if ((n & ~CO_ALL_FEATURES) != 0) {
            throw Py.ValueError("compile(): unrecognised flags");
        }
        return CompilerFlags.getCompilerFlags(new CompilerFlags(n), pyFrame);
    }

    public static CompilerFlags getCompilerFlags(CompilerFlags compilerFlags, PyFrame pyFrame) {
        if (pyFrame != null && pyFrame.f_code != null) {
            return pyFrame.f_code.co_flags.combine(compilerFlags);
        }
        return compilerFlags;
    }

    public CompilerFlags combine(CompilerFlags compilerFlags) {
        return new CompilerFlags(this.toBits() | compilerFlags.toBits());
    }

    public CompilerFlags combine(int n) {
        return new CompilerFlags(this.toBits() | n);
    }
}

